<?php defined('SYSPATH') or die('No direct script access.');

class Controller_Email extends CheckAction {

	public function action_index(){
        /* RESET */
        if (null !== $this->request->post('reset')) {
            Session::instance()->delete('email');
            HTTP::redirect('/email/');
        }

        /* Save filter and redirect */
        if (Request::POST == $this->request->method() && ( null !== $this->request->post('filter') || null !== $this->request->post('download_filter'))) {
            $session = Session::instance();
            $session->set('email', $this->request->post());
            HTTP::redirect('/email/');
        }

        /* If isset session set post data */
        if (Session::instance()->get('email')) {
            $post = Session::instance()->get('email');
            $this->request->post($post);
        } else {
            $post = $this->request->post();
        }

        $limit = 20;
        $locations = array_values(Kohana::$config->load('locations')->as_array());
        $locations = array_combine($locations, $locations);
        $suffix = Task_Helper::getSuffix();
	    $query = $this->filter($post, $suffix);

        if(isset($post['download_filter'])){
            unset($post['download_filter']);
            Session::instance()->set('email', $post);

            $query->limit(100000)->offset(0);
            $query->add_field('email');
            $emails = $query->order('id', 'desc')->execute()['data'];
            $emails = implode("\r\n", array_unique(Arr::path($emails, ['*', 'email'])));
            $this->download($emails, 'emails.txt');
        }

        $total = clone $query;
        $page = $this->request->param('page');
        $pagination = Pagination::factory([
            'total_items' => $total->execute()['total_info']['total_found'],
            'items_per_page' => $limit,
        ]);

        Model_Logpost::offsetSphinxQL($page, $limit, $query);
        $index = $query->order('id', 'desc')->execute()['data'];

        foreach ($index as $k => $l){
            $client = ORM::factory('Client', $l['client_id']);
            $index[$k]['client'] = $client->getClientID();
            $index[$k]['location'] = $client->location;
            $index[$k]['prefix.client'] = $client->getFullName();
            $index[$k]['referer'] = Model_Logpost::getReferer($l['id']);
            $index[$k]['datetime'] = Model_Logpost::getDatetime($l['id']);
        }

        $this->template->content = View::factory('/email/v_index')
            ->bind('pagination', $pagination)
            ->bind('post', $post)
            ->bind('locations', $locations)
            ->bind('suffix', $suffix)
            ->bind('index', $index);
	}

    public function action_download_all(){
        $emails = file_get_contents(APPPATH.'emails.txt');
        $this->download($emails, 'emails.txt');
    }

    private function filter(&$post, $suffix){
        $sphinxql = new SphinxQL();
        $query = $sphinxql->new_query()->add_index('email');
        $match = '';

        /* CLIENT */
        if (Arr::get($post, 'client') || Arr::get($_GET, 'client')) {
            if(Arr::get($_GET, 'client')){
                $post['client'] = Arr::get($_GET, 'client');
            }
            preg_match('#[a-fA-F0-9]{32}#', Arr::get($post, 'client'), $client);
            if(!empty($client)){
                $client_id = Model_Client::getClientInfo($client[0])['id'];
                $query->where('client_id', $client_id);
                $post['client'] = $client[0];
            }else{
                $query->where('client_id', 0);
            }
        }

        /* START - END */
        if (Arr::get($post, 'date_start') && Arr::get($post, 'date_end')) {
            $start = strtotime($post['date_start']);
            $end = strtotime($post['date_end']);
            $end = strtotime("+1 day", $end);
            $query->where('datetime', $start.' AND '.$end, 'BETWEEN');
        }

        /* COUNTRY ACCESS */
        $post['country_access'] = Auth::instance()->get_user()->getCountryAccess();
        if (Arr::get($post, 'country_access')) {
            $locations = array_map(['Task_Helper', 'locationToInt'], $post['country_access']);
            /* LOCATIONS */
            if(Arr::get($post, 'locations')){
                $locations = array_intersect($locations, array_map(['Task_Helper', 'locationToInt'], $post['locations']));
            }
            $query->where_in('location', $locations ?: 0);
            unset($locations);
        }else{
            /* LOCATIONS */
            if(Arr::get($post, 'locations')){
                $query->where_in('location', array_map(['Task_Helper', 'locationToInt'], $post['locations']));
            }
        }

        /* SUFFIX */
        if(Arr::get($post, 'suffix')){
            $match .= ' @suffix (' . implode(')|(', Arr::extract($suffix, $post['suffix'])) . ") ";
        }

        /* DOMAIN EMAIL */
        if (Arr::get($post, 'email')) {
            $emailOr = $post['email'];
            $emailOr = explode('|', $emailOr);
            $emailsEscaped = [];
            foreach($emailOr as $email) {
                $email = Helper::EscapeSphinxQL($email);
                $emailsEscaped[] = Helper::wrapWithWildcardsAndOptimize($email);
            }
            $match .= " @email (" . implode(')|(', $emailsEscaped) . ") ";
        }

        /* REFERRER */
        if (Arr::get($post, 'referrer')) {
            $referrerOr = $post['referrer'];
            $referrerOr = explode('|', $referrerOr);
            $referrersEscaped = [];
            foreach($referrerOr as $referrer) {
                $referrer = Helper::EscapeSphinxQL($referrer);
                $referrersEscaped[] = Helper::wrapWithWildcardsAndOptimize($referrer);
            }
            $match .= " @referer (" . implode(')|(', $referrersEscaped) . ") ";
        }

        if($match != ''){
            $query->search($match);
        }

        return $query;
    }

    private function download($file, $name){
        header("Content-Length: ".strlen($file));
        header("Content-Type: application/octet-stream");
        header("Content-Transfer-Encoding: binary");
        header("Content-Disposition: attachment; filename=".$name);
        echo $file;
        exit;
    }
}